#include "bullet.h"

Bullet::Bullet(Object *parent, Atom *me, int life) : LifeAtom(parent, me, life) {
	me->draw = false;
	me->interpolate = true;
}

void Bullet::draw() {
	LifeAtom::draw();
	if(me->being_deleted) return;

	const float trail = 0.5f;

	glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
	glBegin(GL_LINES);
		glVertex2f(me->x, me->y);
		//glVertex2f(me->ox, me->oy - 50);
		glVertex2f(me->x + (me->iox - me->x) * trail, me->y + (me->ioy - me->y) * trail);
	glEnd();
}